import 'dart:convert';
import 'package:play_lab/core/helper/string_format_helper.dart';

import '../global/common_api_response_model.dart';

GenreResponseModel genreResponseModelFromJson(String str) => GenreResponseModel.fromJson(json.decode(str));

String genreResponseModelToJson(GenreResponseModel data) => json.encode(data.toJson());

class GenreResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  GenreResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory GenreResponseModel.fromJson(Map<String, dynamic> json) => GenreResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  GenresData? genres;
  String? landscapePath;
  String? portraitPath;

  Data({
    this.genres,
    this.landscapePath,
    this.portraitPath,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        genres: json["genres"] == null ? null : GenresData.fromJson(json["genres"]),
        landscapePath: json["landscape_path"],
        portraitPath: json["portrait_path"],
      );

  Map<String, dynamic> toJson() => {
        // "genres": genres?.toJson(),
        "landscape_path": landscapePath,
        "portrait_path": portraitPath,
      };
}

class GenresData {
  List<GenresCategory>? categories;

  GenresData({
    this.categories,
  });

  factory GenresData.fromJson(Map<String, dynamic> json) {
    final List<GenresCategory> categoryList = [];
    json.forEach((genreName, itemsJson) {
      final List<GenresItem> items = List<GenresItem>.from(itemsJson.map((x) => GenresItem.fromJson(x)));
      categoryList.add(GenresCategory(name: genreName, items: items));
      printX("Cat name -> $genreName");
      printX("Cat values -> ${items.length}");
    });
    return GenresData(categories: categoryList);
  }
}

class GenresCategory {
  String name;
  List<GenresItem>? items;
  GenresCategory({
    required this.name,
    this.items,
  });
}

class GenresItem {
  String? id;
  String? itemType;
  Image? image;

  GenresItem({
    this.id,
    this.itemType,
    this.image,
  });

  factory GenresItem.fromJson(Map<String, dynamic> json) => GenresItem(
        id: json["id"].toString(),
        itemType: json["item_type"]?.toString(),
        image: json["image"] == null ? null : Image.fromJson(json["image"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "item_type": itemType,
        "image": image?.toJson(),
      };
}

class Image {
  String? landscape;
  String? portrait;

  Image({
    this.landscape,
    this.portrait,
  });

  factory Image.fromJson(Map<String, dynamic> json) => Image(
        landscape: json["landscape"]?.toString(),
        portrait: json["portrait"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "landscape": landscape,
        "portrait": portrait,
      };
}
